/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import mod.crend.dynamiccrosshair.impl.CrosshairContextImpl;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dynamiccrosshair");
    HitState previousState;
    HitStateFluid previousFluidState = null;
    class_243 previousPosition;
    public final CrosshairContext context = new CrosshairContextImpl();

    public boolean changed(class_239 hitResult, class_746 player) {
        HitState newState;
        switch (hitResult.method_17783()) {
            default: {
                throw new MatchException(null, null);
            }
            case field_1332: {
                HitState hitState = new HitStateBlock(player, (class_3965)hitResult);
                break;
            }
            case field_1331: {
                HitState hitState = new HitStateEntity(player, (class_3966)hitResult);
                break;
            }
            case field_1333: {
                HitState hitState = newState = new HitStateMiss(player, hitResult);
            }
        }
        if (this.previousState == null) {
            this.previousState = newState;
            return true;
        }
        class_243 newPosition = player.method_19538();
        if (!newPosition.equals((Object)this.previousPosition)) {
            this.previousPosition = newPosition;
            this.previousState = newState;
            this.context.invalidateHitResult(hitResult);
            return true;
        }
        for (DynamicCrosshairApi api : this.context.apis()) {
            try {
                if (!api.forceInvalidate(this.context)) continue;
                this.previousState = newState;
                this.context.invalidateHitResult(hitResult);
                return true;
            }
            catch (RuntimeException e) {
                LOGGER.error("Exception occurred during evaluation of API {}", (Object)api.getModId(), (Object)e);
            }
        }
        if (newState.isChanged(this.previousState)) {
            this.previousState = newState;
            if (this.previousFluidState != null) {
                this.previousFluidState = null;
                this.context.invalidateHitResult(hitResult);
            }
            return true;
        }
        if (!player.method_6030().method_7960()) {
            return true;
        }
        class_3965 fluidHitResult = this.context.raycastWithFluid();
        if (fluidHitResult.method_17783() == class_239.class_240.field_1332) {
            HitStateFluid newFluidState = new HitStateFluid(fluidHitResult);
            if (newFluidState.isChanged(this.previousFluidState)) {
                this.previousFluidState = newFluidState;
                this.context.invalidateHitResult(hitResult);
                return true;
            }
        } else if (this.previousFluidState != null) {
            this.previousFluidState = null;
            this.context.invalidateHitResult(hitResult);
            return true;
        }
        return false;
    }

    private static class HitStateFluid {
        final int level;
        final class_3611 fluid;

        public HitStateFluid(class_3965 fluidHitResult) {
            assert (class_310.method_1551().field_1687 != null);
            class_3610 fluidState = class_310.method_1551().field_1687.method_8316(fluidHitResult.method_17777());
            this.fluid = fluidState.method_15772();
            this.level = this.fluid.method_15779(fluidState);
        }

        public boolean isChanged(HitStateFluid other) {
            return other == null || this.fluid != other.fluid || this.level != other.level;
        }
    }

    private class HitStateBlock
    extends HitState {
        final int x;
        final int y;
        final int z;
        final class_2350 side;
        final class_2680 blockState;

        public HitStateBlock(class_746 player, class_3965 blockHitResult) {
            super(player, (class_239)blockHitResult);
            class_2338 blockPos = blockHitResult.method_17777();
            this.x = blockPos.method_10263();
            this.y = blockPos.method_10264();
            this.z = blockPos.method_10260();
            this.side = blockHitResult.method_17780();
            assert (class_310.method_1551().field_1687 != null);
            this.blockState = class_310.method_1551().field_1687.method_8320(blockPos);
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateBlock) {
                HitStateBlock otherBlock = (HitStateBlock)other;
                if (this.x == otherBlock.x && this.y == otherBlock.y && this.z == otherBlock.z && this.side == otherBlock.side && this.blockState == otherBlock.blockState) {
                    return false;
                }
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitStateEntity
    extends HitState {
        final class_1297 entity;

        public HitStateEntity(class_746 player, class_3966 entityHitResult) {
            super(player, (class_239)entityHitResult);
            this.entity = entityHitResult.method_17782();
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateEntity) {
                HitStateEntity otherEntity = (HitStateEntity)other;
                if (this.entity == otherEntity.entity) {
                    return false;
                }
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitStateMiss
    extends HitState {
        public HitStateMiss(class_746 player, class_239 hitResult) {
            super(player, hitResult);
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateMiss) {
                return false;
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitState {
        final class_239 hitResult;
        final class_1799 mainHandStack;
        final class_1799 offHandStack;
        final class_1799 activeStack;
        final class_1268 activeHand;
        final boolean cancelInteraction;
        final boolean isCoolingDown;
        final boolean isOnGround;
        final boolean isGliding;

        public HitState(class_746 player, class_239 hitResult) {
            this.hitResult = hitResult;
            this.mainHandStack = player.method_6047().method_7972();
            this.offHandStack = player.method_6079().method_7972();
            this.activeStack = player.method_6030().method_7972();
            this.activeHand = player.method_6058();
            this.cancelInteraction = player.method_21823();
            this.isCoolingDown = player.method_7357().method_7904(this.mainHandStack.method_7909()) || player.method_7357().method_7904(this.offHandStack.method_7909());
            this.isOnGround = player.method_24828();
            this.isGliding = player.method_6128();
        }

        public boolean isChanged(HitState other) {
            boolean invalidated = false;
            if (!class_1799.method_7973((class_1799)this.mainHandStack, (class_1799)other.mainHandStack)) {
                State.this.context.invalidateItem(class_1268.field_5808);
                invalidated = true;
            }
            if (!class_1799.method_7973((class_1799)this.offHandStack, (class_1799)other.offHandStack)) {
                State.this.context.invalidateItem(class_1268.field_5810);
                invalidated = true;
            }
            if (!class_1799.method_7973((class_1799)this.activeStack, (class_1799)other.activeStack)) {
                State.this.context.invalidateItem(this.activeHand);
                invalidated = true;
            }
            return invalidated || this.cancelInteraction != other.cancelInteraction || this.isCoolingDown != other.isCoolingDown || this.isOnGround != other.isOnGround || this.isGliding != other.isGliding;
        }
    }
}

